/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.plant;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.assets.entities.plant.PlantEntityAssetsByHeight;
import technology.rocketjump.undermount.assets.entities.plant.model.PlantEntityAsset;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;

public class PlantEntityAssetsByType {
    private Map<EntityAssetType, PlantEntityAssetsByHeight> typeMap = new HashMap<EntityAssetType, PlantEntityAssetsByHeight>();

    public PlantEntityAssetsByType(EntityAssetTypeDictionary typeDictionary, PlantSpeciesDictionary plantSpeciesDictionary) {
        for (EntityAssetType assetType : typeDictionary.getByEntityType(EntityType.PLANT)) {
            this.typeMap.put(assetType, new PlantEntityAssetsByHeight(plantSpeciesDictionary));
        }
    }

    public void add(PlantEntityAsset asset) {
        this.typeMap.get(asset.getType()).add(asset);
    }

    public PlantEntityAsset get(EntityAssetType type, PlantEntityAttributes attributes) {
        return this.typeMap.get(type).get(attributes);
    }

    public List<PlantEntityAsset> getAll(EntityAssetType type, PlantEntityAttributes attributes) {
        return this.typeMap.get(type).getAll(attributes);
    }
}

